/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.common.util.HMCPhysicalMem;
import com.ibm.hsc.common.util.HSCVPD;
import java.io.IOException;

public class HMCBios {
    byte[] tables = null;
    long tableLen = 0L;
    int majorVersion = 0;
    int minorVersion = 0;

    public HMCBios() {
        this.readSmbios();
    }

    public boolean isSmbiosPresent() {
        return this.tables != null;
    }

    public int getSmbiosMajorVersion() {
        return this.majorVersion;
    }

    public int getSmbiosMinorVersion() {
        return this.minorVersion;
    }

    public boolean readSmbios() {
        int n = 0;
        long l = 0L;
        try {
            HMCPhysicalMem hMCPhysicalMem = new HMCPhysicalMem();
            byte[] byArray = new byte[65536];
            hMCPhysicalMem.setAddress(983040L);
            hMCPhysicalMem.read(byArray);
            hMCPhysicalMem.close();
            boolean bl = false;
            for (int i = 0; i <= 65520; i += 16) {
                if (byArray[i + 0] != 95 || byArray[i + 1] != 68 || byArray[i + 2] != 77 || byArray[i + 3] != 73 || byArray[i + 4] != 95) continue;
                n = HSCVPD.MakeUCHAR(byArray[i + 7]) * 256 + HSCVPD.MakeUCHAR(byArray[i + 6]);
                l = (long)HSCVPD.MakeUCHAR(byArray[i + 11]) * 0x1000000L + (long)HSCVPD.MakeUCHAR(byArray[i + 10]) * 65536L + (long)HSCVPD.MakeUCHAR(byArray[i + 9]) * 256L + (long)HSCVPD.MakeUCHAR(byArray[i + 8]);
                byte by = 0;
                for (int j = 0; j < 15; ++j) {
                    by = (byte)(by + byArray[i + j]);
                }
                if (by != 0) continue;
                bl = true;
                this.minorVersion = HSCVPD.MakeUCHAR(byArray[i + 14]) & 0xF;
                this.majorVersion = HSCVPD.MakeUCHAR(byArray[i + 14]) >> 4;
                if (i <= 16 || byArray[i - 16 + 0] != 95 || byArray[i - 16 + 1] != 83 || byArray[i - 16 + 2] != 77 || byArray[i - 16 + 3] != 95) break;
                this.minorVersion = HSCVPD.MakeUCHAR(byArray[i - 16 + 7]);
                this.majorVersion = HSCVPD.MakeUCHAR(byArray[i - 16 + 6]);
                break;
            }
            if (bl) {
                this.tableLen = n;
                this.tables = new byte[n];
                hMCPhysicalMem = new HMCPhysicalMem();
                hMCPhysicalMem.setAddress(l);
                hMCPhysicalMem.read(this.tables);
                hMCPhysicalMem.close();
                return true;
            }
        }
        catch (IOException iOException) {
            System.out.println("IO Exception...");
        }
        return false;
    }

    public byte[] getTables() {
        return this.tables;
    }

    public long length() {
        return this.tableLen;
    }

    public String getSmbiosString(int n, int n2) {
        if (this.tables == null) {
            return null;
        }
        if (n2 < 1) {
            return null;
        }
        int n3 = HSCVPD.MakeUCHAR(this.tables[n + 1]);
        int n4 = n3;
        if (this.tables[n + n4] == 0) {
            return null;
        }
        for (int i = 1; i < n2; ++i) {
            while (this.tables[n + n4] != 0) {
                if ((long)(n + n4) >= this.tableLen) {
                    return null;
                }
                ++n4;
            }
            if (this.tables[n + ++n4] != 0) continue;
            return null;
        }
        int n5 = 0;
        while (this.tables[n + n4 + n5] != 0) {
            if ((long)(n + n4 + n5) >= this.tableLen) {
                return null;
            }
            ++n5;
        }
        return new String(this.tables, n + n4, n5);
    }

    int nextStruct(int n) {
        int n2;
        if (this.tables == null) {
            return 0;
        }
        if ((long)(n + 1) >= this.tableLen) {
            return 0;
        }
        int n3 = HSCVPD.MakeUCHAR(this.tables[n + 1]);
        for (n2 = n + n3; n2 != 0 && (long)n2 < this.tableLen && (this.tables[n2] != 0 || this.tables[n2 + 1] != 0); ++n2) {
            if ((long)n2 < this.tableLen) continue;
            return 0;
        }
        return n2 + 2;
    }

    public int findNextStruct(int n, int n2) {
        if (this.tables == null) {
            return -1;
        }
        int n3 = 0;
        if (n != -1 && (n3 = this.nextStruct(n)) == 0) {
            return -1;
        }
        while ((long)n3 < this.tableLen && HSCVPD.MakeUCHAR(this.tables[n3]) != n2) {
            if ((n3 = this.nextStruct(n3)) != 0) continue;
            return -1;
        }
        if ((long)n3 < this.tableLen && HSCVPD.MakeUCHAR(this.tables[n3]) == n2) {
            return n3;
        }
        return -1;
    }

    public int findOEMStruct(String string) {
        if (this.tables == null) {
            return -1;
        }
        int n = 0;
        while ((long)n < this.tableLen) {
            if (HSCVPD.MakeUCHAR(this.tables[n]) >= 128 && this.getSmbiosString(n, 1).equals(string)) {
                return HSCVPD.MakeUCHAR(this.tables[n]);
            }
            if ((n = this.nextStruct(n)) != 0) continue;
            return -1;
        }
        return -1;
    }
}

